/*
    Copyright 2015 Adobe Systems Incorporated.  All rights reserved. 
*/

/*global require, module, console */
/*jslint es5: true */

var socketFactory = require('./socketFactory.js');

function MouseHoverInCommand(socket, data) {
    "use strict";
    this.io = socketFactory.io;
    this.socket = socket;
    this.data = data;
}

MouseHoverInCommand.prototype.execute = function () {
    "use strict";
    var socketId = this.data.id;
    this.io.to(socketId).emit('mouse:in', this.data);
};

function MouseHoverOutCommand(socket, data) {
    "use strict";
    this.io = socketFactory.io;
    this.socket = socket;
    this.data = data;
}


MouseHoverOutCommand.prototype.execute = function () {
    "use strict";
    var socketId = this.data;
    this.io.to(socketId).emit('mouse:out', null);
};

module.exports.MouseHoverInCommand = MouseHoverInCommand;
module.exports.MouseHoverOutCommand = MouseHoverOutCommand;